(function($, window, document, undefined) {

    "use strict";

    // create the defaults once
    var pluginName = "easytheme",
        defaults = {
            // themes
            ct_normal_elm: ".easytheme-normal-btn",
            ct_light_elm: ".easytheme-light-btn",
            ct_color_elm: ".easytheme-color-btn",
            ct_dark_elm: ".easytheme-dark-btn",
            ct_grayscale_elm: ".easytheme-grayscale-btn",
            ct_reset_elm: ".easytheme-contrast-reset",
            // toolbar
            tb_wrapper_elm: "#easytheme-toolbarWrap",
            tb_btn_elm: ".easytheme_hide_toolbar",
            // fontsizer
            fontsizer_tags: "a,p,b,span,label,div,h1,h2,h3,h4,h5,h6",
            fontsizer_size_jump: 1,
            fontsizer_increase_elm: "#easytheme-fontsizer button.big-letter",
            fontsizer_decrease_elm: "#easytheme-fontsizer button.small-letter",
            fontsizer_reset_elm: ".easytheme-font-reset",
        };

    // plugin constructor
    function Plugin(element, options) {
        this.element = element;
        this.settings = $.extend({}, defaults, options);
        this._defaults = defaults;
        this._name = pluginName;
        this.init();

    }

    // avoid Plugin.prototype conflicts
    $.extend(Plugin.prototype, {
        init: function() {

            // console.log("start init easytheme");

            this.initToolbar(this.settings);
            this.initFontSizer(this.settings);
            this.initContrast(this.settings);

            // console.log("end init easytheme");

        },

        initToolbar: function(plg_settings) {

            $(plg_settings.tb_btn_elm).click(function(event) {

                $(plg_settings.tb_wrapper_elm).toggleClass("close-toolbar");

                if ($(plg_settings.tb_wrapper_elm).hasClass('close-toolbar')) {
                    $(plg_settings.tb_wrapper_elm).children("a, button,h3").attr('tabindex', '-1');
                } else {
                    $(plg_settings.tb_wrapper_elm).children("a, button,h3").attr('tabindex', '0');
                }

            });

            $(plg_settings.tb_btn_elm).focus(function(event) {

                $(plg_settings.tb_wrapper_elm).toggleClass("close-toolbar");

                if ($(plg_settings.tb_wrapper_elm).hasClass('close-toolbar')) {
                    $(plg_settings.tb_wrapper_elm).children("a, button,h3").attr('tabindex', '-1');
                } else {
                    $(plg_settings.tb_wrapper_elm).children("a, button,h3").attr('tabindex', '0');
                }

            });
        },

        initContrast: function(plg_settings) {

            var easytheme_light = localStorage.getItem('easytheme_light');
            var easytheme_color = localStorage.getItem('easytheme_color');
            var easytheme_dark = localStorage.getItem('easytheme_dark');
            var easytheme_grayscale = localStorage.getItem('easytheme_grayscale');

            // normal theme
            $(plg_settings.ct_normal_elm).click(this, function() {

                localStorage.removeItem('easytheme_light');
                localStorage.removeItem('easytheme_color');
                localStorage.removeItem('easytheme_dark');
                localStorage.removeItem('easytheme_grayscale');

                $(plg_settings.ct_normal_elm).addClass('easytheme-hide');

                $('body').removeClass('easytheme-light easytheme-color easytheme-dark easytheme-grayscale');
            });

            // light theme
            $(plg_settings.ct_light_elm).click(this, function() {
                localStorage.removeItem('easytheme_color');
                localStorage.removeItem('easytheme_dark');
                localStorage.removeItem('easytheme_grayscale');
                localStorage.setItem('easytheme_light', 'light', 1);

                $('body')
                    .removeClass('easytheme-color easytheme-dark easytheme-grayscale')
                    .addClass('easytheme-light');

                $(plg_settings.ct_normal_elm).removeClass('easytheme-hide');
            });

            // color theme
            $(plg_settings.ct_color_elm).click(this, function() {
                localStorage.removeItem('easytheme_light');
                localStorage.removeItem('easytheme_dark');
                localStorage.removeItem('easytheme_grayscale');
                localStorage.setItem('easytheme_color', 'color', 1);

                $('body')
                    .removeClass('easytheme-light easytheme-dark easytheme-grayscale')
                    .addClass('easytheme-color');

                $(plg_settings.ct_normal_elm).removeClass('easytheme-hide');
            });

            // dark theme
            $(plg_settings.ct_dark_elm).click(function() {
                localStorage.removeItem('easytheme_light');
                localStorage.removeItem('easytheme_color');
                localStorage.removeItem('easytheme_grayscale');
                localStorage.setItem('easytheme_dark', 'dark', 1);

                $('body')
                    .removeClass('easytheme-light easytheme-color easytheme-grayscale')
                    .addClass('easytheme-dark');

                $(plg_settings.ct_normal_elm).removeClass('easytheme-hide');
            });

            // grayscale
            $(plg_settings.ct_grayscale_elm).click(function() {
                localStorage.removeItem('easytheme_light');
                localStorage.removeItem('easytheme_color');
                localStorage.removeItem('easytheme_dark');
                localStorage.setItem('easytheme_grayscale', 'grayscale', 1);

                $('body')
                    .removeClass('easytheme-light easytheme-color easytheme-dark')
                    .addClass("easytheme-grayscale");

                $(plg_settings.ct_reset_elm).removeClass('easytheme-hide');

            });

            // contrast reset
            $(plg_settings.ct_reset_elm).click(this, function() {

                localStorage.removeItem('easytheme_light');
                localStorage.removeItem('easytheme_color');
                localStorage.removeItem('easytheme_dark');
                localStorage.removeItem('easytheme_grayscale');

                $(plg_settings.ct_reset_elm).addClass('easytheme-hide');

                $('body').removeClass('easytheme-light easytheme-color easytheme-dark easytheme-grayscale');
            });

            // initialize from localStorage
            if (easytheme_light) {
                $('body')
                    .removeClass('easytheme-color easytheme-dark easytheme-grayscale')
                    .addClass('easytheme-light');

                $(plg_settings.ct_normal_elm).removeClass('easytheme-hide');
            }

            if (easytheme_color) {
                $('body')
                    .removeClass('easytheme-light easytheme-dark easytheme-grayscale')
                    .addClass('easytheme-color');

                $(plg_settings.ct_normal_elm).removeClass('easytheme-hide');
            }

            if (easytheme_dark) {
                $('body')
                    .removeClass('easytheme-light easytheme-color easytheme-grayscale')
                    .addClass('easytheme-dark');

                $(plg_settings.ct_normal_elm).removeClass('easytheme-hide');
            }

            if (easytheme_grayscale) {
                $('body')
                    .removeClass('easytheme-light easytheme-color easytheme-dark')
                    .addClass('easytheme-grayscale');

                $(plg_settings.ct_reset_elm).removeClass('easytheme-hide');
            }

        },

        initFontSizer: function(plg_settings) {

            //increase
            $(plg_settings.fontsizer_increase_elm).click(function() {

                $(plg_settings.fontsizer_tags).filter(function(index, elm) {


                    $(elm).css('font-size', function() {
                        var fontSizeStrArray = new Array("medium", "xx-small", "x-small", "small", "large", "x-large", "xx-large");
                        console.log($(this));
                        if (fontSizeStrArray.indexOf($(this).css('font-size')) != -1) {
                            alert(fontSizeStrArray.indexOf($(this).css('font-size')) + ', ' + $(this).css('font-size'));
                            return 'larger';
                        } else {
                            return parseInt($(elm).css('font-size')) + plg_settings.fontsizer_size_jump + 'px';
                        }
                    });
                });

                $(plg_settings.fontsizer_reset_elm).removeClass('easytheme-hide');

            });

            // decrease
            $(plg_settings.fontsizer_decrease_elm).click(function() {

                $(plg_settings.fontsizer_tags).filter(function(index) {
                    var fontSizeStrArray = new Array("medium", "xx-small", "x-small", "small", "large", "x-large", "xx-large");
                    if (fontSizeStrArray.indexOf($(this).css('font-size')) != -1) {
                        return 'smaller';
                    } else {
                        $(this).css('font-size', function() {
                            return parseInt($(this).css('font-size')) - plg_settings.fontsizer_size_jump + 'px';
                        });
                    }
                });

                $(plg_settings.fontsizer_reset_elm).removeClass('easytheme-hide');

            });

            // reset to default
            $(plg_settings.fontsizer_reset_elm).click(function() {

                $(plg_settings.fontsizer_tags).filter(function(index) {
                    $(this).attr("style", "");
                });
                // hide reset button after pressing
                $(plg_settings.fontsizer_reset_elm).addClass('easytheme-hide');

            });
        }


    });

    // lightweight plugin wrapper around the constructor, preventing against multiple instantiations
    $.fn[pluginName] = function(options) {
        return this.each(function() {
            if (!$.data(this, "plugin_" + pluginName)) {
                $.data(this, "plugin_" + pluginName, new Plugin(this, options));
            }
        });
    };

})(jQuery, window, document);

function deselect(e) {
    jQuery('.pop').slideFadeToggle(function() {
        e.removeClass('selected');
    });
}

jQuery.fn.slideFadeToggle = function(easing, callback) {
    return this.animate({
        opacity: 'toggle',
        height: 'toggle'
    }, 'fast', easing, callback);
};

// activate plugin after dom ready
jQuery(document).ready(function($) {
    var ajaxUrl = 'index.php?option=com_ajax&module=easytheme&format=json&method=get';
    var data = {
        action: 'easytheme_toolbar_ajax',
    };
    $.post(ajaxUrl, data, function(response) {
        $('.easytheme-show-statement').on('click', function() {
            if ($(this).hasClass('selected')) {
                deselect($(this));
            } else {
                $(this).addClass('selected');
                $('.pop').slideFadeToggle();
            }
            return false;
        });

        $('.close').on('click', function() {
            deselect($('.easytheme-show-statement'));
            return false;
        });
        $(this).easytheme(jQuery.parseJSON(response.data));
    });
});