<?php

/**
 * @license GNU/GPL
 **/

namespace easywidgetNamespace\Module\easywidget\Site\Helper;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Date\Date;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;

class easywidgetHelper
{
    const WEATHER_CODES_TRANSLATIONS = array(
        '0' => 'WEATHER_CODE_0',
        '1' => 'WEATHER_CODE_1',
        '2' => 'WEATHER_CODE_2',
        '3' => 'WEATHER_CODE_3',
        '45' => 'WEATHER_CODE_45',
        '48' => 'WEATHER_CODE_48',
        '51' => 'WEATHER_CODE_51',
        '53' => 'WEATHER_CODE_53',
        '55' => 'WEATHER_CODE_55',
        '56' => 'WEATHER_CODE_56',
        '57' => 'WEATHER_CODE_57',
        '61' => 'WEATHER_CODE_61', 
        '63' => 'WEATHER_CODE_63', 
        '65' => 'WEATHER_CODE_65',
        '66' => 'WEATHER_CODE_66',
        '67' => 'WEATHER_CODE_67',
        '71' => 'WEATHER_CODE_71', 
        '73' => 'WEATHER_CODE_73', 
        '75' => 'WEATHER_CODE_75',
        '77' => 'WEATHER_CODE_77',
        '80' => 'WEATHER_CODE_80', 
        '81' => 'WEATHER_CODE_81', 
        '82' => 'WEATHER_CODE_82', 
        '85' => 'WEATHER_CODE_85', 
        '86' => 'WEATHER_CODE_86',
        '95' => 'WEATHER_CODE_95',
        '96' => 'WEATHER_CODE_96',
        '99' => 'WEATHER_CODE_99',
    );

    public static function getStart($params)
    {
        $x = $params->get('api_choose');
        switch ($x) {
            case 2:
                $loc_array = array(
                    self::getIpgeoloc($params)["latitude"],
                    self::getIpgeoloc($params)["longitude"],
                    self::getIpgeoloc($params)["city"]
                );
                break;
            case 3:
                $loc_array = [$params->get('lat'), $params->get('lon')];
                break;
            default:
                $loc_array = self::getIpGeoplugin($params);
        }
        return $loc_array;
    }

    public static function getSource($params)
    {
        $x = $params->get('weather_source_choose');
        switch ($x) {
            case 0:
                // ...
                break;
            case 1:
                // ...
                break;
            case 2:
                // ...
                break;
            case 6:
                $json = file_get_contents('https://api.open-meteo.com/v1/forecast?latitude=' . self::getStart($params)[0] . '&longitude=' . self::getStart($params)[1] . '&current_weather=true&timezone=auto');
                $obj = json_decode($json, true);

                // METEO TRANSLATION CODE
                $weatherCode = $obj['current_weather']['weathercode'];
                $translatedWeather = Text::_('WEATHER_CODE_' . $weatherCode);

                return [
                    $weatherCode,
                    $translatedWeather,
                    $obj['current_weather']['temperature'],
                    $obj['current_weather']['windspeed'],
                    $obj['current_weather']['winddirection'],
                    $obj['current_weather']['time'],
                    $obj['timezone']
                ];
                break;

            case 5:
                // ...
                break;

            case 3:
                // ...
                break;
            default:
                break;
        }
    }

    public static function getNames($params)
    {
        $openmeteo = array(
            'WEATHER_ICON',
            'WEATHER_MAIN',
            'TEMPERC',
            'WINDSPEED',
            'WINDDIRECTION',
            'TIME',
            'TIMEZONE'
        );
        $x = $params->get('weather_source_choose');
        switch ($x)
        {
            case 0:
                return array_merge($main, $wwo0);
            break;
            case 1:
                return array_merge($main, $sun);
            break;
            case 3:
                return array_merge($main, $wwo0, $wwo3);
            break;
            case 5:
                return array_merge($main, $sun, $vc);
            break;
            case 6:
                return $openmeteo;
            break;
            default:
                return $main;
        }
    }

    public static function getValues($params)
    {
        $openmeteo = array(
            $params->get('img') ,
            $params->get('title') ,
            $params->get('temperature') ,
            $params->get('windspeed') ,
            $params->get('winddirection') ,
            $params->get('time') ,
            $params->get('timezone')
        );

        $x = $params->get('weather_source_choose');
        switch ($x)
        {
            case 0:
                return array_merge($main, $wwo0);
            break;
            case 1:
                return array_merge($main, $owm);
            break;
            case 3:
                return array_merge($main, $wwo0, $wwo3);
            break;
            case 5:
                return array_merge($main, $vc);
            break;
            case 6:
                return $openmeteo;
            break;
            default:
                return $main;
        }
    }

    public static function getLang()
    {
        $lang = Factory::getLanguage()->getTag();
        return substr($lang, 0, 2);
    }

    public static function getIp($params)
    {
        return $_SERVER['REMOTE_ADDR'];
    }

    public static function getIpgeoloc($params)
    {
        $apiKey = $params->get('api_key_geoloc');
        $lang = self::getLang($params);
        $fields = "*";
        $excludes = "";
        $url = "https://api.ipgeolocation.io/ipgeo?apiKey=" . $apiKey . "&ip=" . self::getIp($params) . "&lang=" . $lang . "&fields=" . $fields . "&excludes=" . $excludes;
        $cURL = curl_init();
        curl_setopt($cURL, CURLOPT_URL, $url);
        curl_setopt($cURL, CURLOPT_HTTPGET, true);
        curl_setopt($cURL, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($cURL, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            'Accept: application/json'
        ));
        return json_decode(curl_exec($cURL) , true);
    }

    public static function getIpGeoplugin($params)
    {
        $json = file_get_contents('http://www.geoplugin.net/json.gp?ip=' . self::getIp($params));
        $obj = json_decode($json, true);
        return [$obj['geoplugin_latitude'], $obj['geoplugin_longitude'], $obj['geoplugin_city']];
    }

    public static function icons_open_meteo($x)
    {
  if ($x == '0') {
    return 'clear-day';
} elseif (in_array($x, ['1','2','3'])) { 
    return 'partly-cloudy-day';
} elseif (in_array($x, ['45','48'])) { 
    return 'fog';
} elseif (in_array($x, ['51','53','55','56','57'])) { 
    return 'hail';
} elseif (in_array($x, ['61','63','65','66','67','80','81','82'])) { 
    return 'rain';
} elseif (in_array($x, ['71','73','75','77','85','86'])) { 
    return 'snow';
} elseif (in_array($x, ['95','96','99'])) { 
    return 'thunder';
}
    }
}
